/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.tileentities;

import com.gollum.core.ModGollumCoreLib;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityBlockProximitySpawn
extends TileEntity {
    private String mobID;
    short delay = (short)30;

    public void setModId(String modId) {
        this.mobID = modId;
    }

    public void updateEntity() {
        if (this.mobID != null && !this.worldObj.isRemote) {
            if (this.delay > 0) {
                this.delay = (short)(this.delay - 1);
                return;
            }
            Entity entity = EntityList.createEntityByName((String)this.mobID, (World)this.worldObj);
            if (entity == null) {
                ModGollumCoreLib.log.warning("This mob " + this.mobID + " isn't  register");
                return;
            }
            this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, 0, 0, 2);
            double x = (double)this.xCoord + 0.5;
            double y = this.yCoord;
            double z = (double)this.zCoord + 0.5;
            EntityLiving entityLiving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
            entity.setLocationAndAngles(x, y, z, this.worldObj.rand.nextFloat() * 360.0f, this.worldObj.rand.nextFloat() * 360.0f);
            this.worldObj.spawnEntityInWorld(entity);
            if (entityLiving == null || entityLiving.getCanSpawnHere()) {
                this.worldObj.playSoundEffect((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, "dig.stone", 0.5f, this.worldObj.rand.nextFloat() * 0.25f + 0.6f);
                if (entityLiving != null) {
                    entityLiving.spawnExplosionParticle();
                }
            }
        }
    }

    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        String mobID = var1.getString("mobID");
        if (!mobID.equals("")) {
            this.mobID = mobID;
        }
        this.delay = var1.getShort("delay");
    }

    public void writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        String mobID = this.mobID != null ? this.mobID : "";
        var1.setString("mobID", mobID);
        var1.setShort("delay", this.delay);
    }
}

