/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.resources;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.resources.ResourcePack;
import com.gollum.core.common.resources.data.MetadataSection;
import com.gollum.core.common.resources.data.MetadataSerializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.imageio.ImageIO;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public abstract class AbstractResourcePack
implements ResourcePack {
    protected final File resourcePackFile;

    public AbstractResourcePack(File par1File) {
        this.resourcePackFile = par1File;
    }

    private static String locationToName(ResourceLocation par0ResourceLocation) {
        return String.format("%s/%s/%s", "assets", par0ResourceLocation.getResourceDomain(), par0ResourceLocation.getResourcePath());
    }

    protected static String getRelativeName(File par0File, File par1File) {
        return par0File.toURI().relativize(par1File.toURI()).getPath();
    }

    @Override
    public InputStream getInputStream(ResourceLocation par1ResourceLocation) throws IOException {
        return this.getInputStreamByName(AbstractResourcePack.locationToName(par1ResourceLocation));
    }

    @Override
    public boolean resourceExists(ResourceLocation par1ResourceLocation) {
        return this.hasResourceName(AbstractResourcePack.locationToName(par1ResourceLocation));
    }

    protected abstract InputStream getInputStreamByName(String var1) throws IOException;

    protected abstract boolean hasResourceName(String var1);

    protected void logNameNotLowercase(String par1Str) {
        ModGollumCoreLib.log.warning("ResourcePack: ignored non-lowercase namespace: %s in %s", new Object[]{par1Str, this.resourcePackFile});
    }

    @Override
    public MetadataSection getPackMetadata(MetadataSerializer par1MetadataSerializer, String par2Str) throws IOException {
        return AbstractResourcePack.readMetadata(par1MetadataSerializer, this.getInputStreamByName("pack.mcmeta"), par2Str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MetadataSection readMetadata(MetadataSerializer par0MetadataSerializer, InputStream par1InputStream, String par2Str) {
        JsonObject jsonobject = null;
        BufferedReader bufferedreader = null;
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(par1InputStream));
            jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedreader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedreader);
        return par0MetadataSerializer.parseMetadataSection(par2Str, jsonobject);
    }

    @Override
    public BufferedImage getPackImage() throws IOException {
        return ImageIO.read(this.getInputStreamByName("pack.png"));
    }

    @Override
    public String getPackName() {
        return this.resourcePackFile.getName();
    }
}

