/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.handlers;

import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.building.Builder;
import com.gollum.core.common.events.BuildingGenerateEvent;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WorldHandler {
    boolean mustBeSave = false;

    @ForgeSubscribe
    public void onSave(ChunkDataEvent.Save event) {
        if (!event.world.isRemote) {
            for (Thread thread : Builder.currentBuilds) {
                if (!thread.isAlive()) continue;
                this.mustBeSave = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForgeSubscribe
    public void onUnload(WorldEvent.Unload event) {
        if (!event.world.isRemote) {
            for (Builder.BuilderRunnable thread : Builder.currentBuilds) {
                if (thread.isAlive()) {
                    try {
                        ModGollumCoreLib.log.message("Wait finish building");
                        while (thread.isAlive()) {
                            thread.dontWaitWorld();
                            Object object = thread.waiter;
                            synchronized (object) {
                                thread.waiter.notify();
                            }
                            Thread.sleep(500L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                BuildingGenerateEvent.Post newEvent = new BuildingGenerateEvent.Post(event.world, thread.getBuilding(), thread.getRotate(), thread.getPosition());
                MinecraftForge.EVENT_BUS.post((Event)newEvent);
                this.mustBeSave = true;
            }
            if (this.mustBeSave) {
                ModGollumCoreLib.log.message("Resave after building...");
                try {
                    ((WorldServer)event.world).saveAllChunks(true, (IProgressUpdate)null);
                    ModGollumCoreLib.log.message("Resave after building : DONE");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Builder.currentBuilds.clear();
            this.mustBeSave = false;
            ModGollumCoreLib.log.debug("=========== UnloadEvent ===========");
        }
    }
}

