/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GCLContainer
extends Container {
    public static final int SIZE_BORDER_BOTTOM = 7;
    public static final int SIZE_BORDER_TOP = 15;
    public static final int SIZE_BORDER_SIDE = 7;
    public static final int SIZE_ITEM = 18;
    public static final int SIZE_PLAYER_INVENTORY = 101;
    protected IInventory inventoryBlock;
    protected int numRows;
    protected int numColumns;

    public GCLContainer(IInventory inventoryPlayer, IInventory inventoryBlock, int numColumns) {
        int j;
        int i;
        this.inventoryBlock = inventoryBlock;
        this.numColumns = numColumns;
        this.numRows = (int)Math.ceil((double)inventoryBlock.getSizeInventory() / (double)this.numColumns);
        inventoryBlock.openChest();
        int height = (this.numRows - 4) * 18;
        int distance = 106;
        int widthTop = 14 + 18 * this.numColumns;
        int xTop = (177 - widthTop) / 2;
        xTop = xTop < 0 ? xTop - 1 : xTop;
        int slot = 0;
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numColumns; ++j) {
                if (slot < inventoryBlock.getSizeInventory()) {
                    this.addSlotToContainer(new Slot(inventoryBlock, slot, 7 + j * 18 + 1 + xTop, 15 + i * 18 - 2));
                }
                ++slot;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot(inventoryPlayer, j + i * 9 + 9, 8 + j * 18, distance + i * 18 + height));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot(inventoryPlayer, i, 8 + i * 18, 58 + distance + height));
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotId) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotId);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemStack = itemstack1.copy();
            if (slotId < this.numRows * this.numColumns ? !this.mergeItemStack(itemstack1, this.numRows * this.numColumns, this.inventorySlots.size(), true) : !this.mergeItemStack(itemstack1, 0, this.numRows * this.numColumns, false)) {
                return null;
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemStack;
    }

    public boolean canInteractWith(EntityPlayer par1EntityPlayer) {
        return this.inventoryBlock.isUseableByPlayer(par1EntityPlayer);
    }

    public void onContainerClosed(EntityPlayer par1EntityPlayer) {
        super.onContainerClosed(par1EntityPlayer);
        this.inventoryBlock.closeChest();
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumColumns() {
        return this.numColumns;
    }
}

