/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.config;

import com.gollum.core.common.config.ConfigLoader;
import com.gollum.core.common.context.ModContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class Config
implements Cloneable {
    private String fileName = "";
    private String relativePath = "";
    private boolean isMain = false;

    public Config() {
        this(ModContext.instance().getCurrent().getModId());
        this.isMain = true;
    }

    public Config(String fileName) {
        this.fileName = fileName;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Config loadConfig() {
        ConfigLoader configLoader = new ConfigLoader(this);
        configLoader.loadConfig();
        return this;
    }

    public Object clone() {
        Config cloned = this;
        try {
            cloned = (Config)super.clone();
            try {
                for (Field f : cloned.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    try {
                        Object oldField = f.get(this);
                        Object newField = oldField.getClass().getMethod("clone", new Class[0]).invoke(oldField, new Object[0]);
                        f.set(cloned, newField);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cloned;
    }

    public boolean equals(Object value) {
        boolean equal = true;
        if (value instanceof Config) {
            try {
                for (Field f : this.getClass().getDeclaredFields()) {
                    if (!f.isAccessible() || !Modifier.isStatic(f.getModifiers()) || !(f.get(this) == null ? f.get(value) != null : !f.get(this).equals(f.get(value)))) continue;
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isMain() {
        return this.isMain;
    }
}

