/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.command;

import com.gollum.core.common.building.Builder;
import com.gollum.core.common.building.Building;
import com.gollum.core.common.building.BuildingParser;
import com.gollum.core.inits.ModItems;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatMessageComponent;

public class CommandBuilding
extends CommandBase {
    public String getCommandName() {
        return "building";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "building [reload, rebuild]";
    }

    public String getCommandUsageRebuild(ICommandSender sender) {
        return "building rebuild <num last building>";
    }

    public void processCommand(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new WrongUsageException(this.getCommandUsage(sender), new Object[0]);
        }
        if (arguments[0].matches("reload")) {
            sender.sendChatToPlayer(ChatMessageComponent.createFromText((String)"Reload all buildings"));
            BuildingParser.reloadAll();
        } else if (arguments[0].matches("rebuild")) {
            try {
                int last = 0;
                if (arguments.length >= 2) {
                    last = Integer.parseInt(arguments[1]);
                }
                Building.SubBuilding subBuilding = ModItems.itemBuilding.getLastBuild(last);
                sender.sendChatToPlayer(ChatMessageComponent.createFromText((String)("Rebuild last building " + subBuilding.building.modId + ":" + subBuilding.building.name)));
                subBuilding.building = new BuildingParser().parse(subBuilding.building.name, subBuilding.building.modId);
                new Builder().build(sender.getEntityWorld(), subBuilding, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new WrongUsageException(this.getCommandUsageRebuild(sender), new Object[0]);
            }
        } else {
            throw new WrongUsageException(this.getCommandUsage(sender), new Object[0]);
        }
    }

    public List addTabCompletionOptions(ICommandSender sender, String[] arguments) {
        List rtn = null;
        rtn = arguments.length == 1 ? CommandBuilding.getListOfStringsMatchingLastWord((String[])arguments, (String[])new String[]{"reload", "rebuild"}) : rtn;
        return rtn;
    }
}

