/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.core.common.building;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import com.gollum.core.ModGollumCoreLib;
import com.gollum.core.common.building.Building;
import com.gollum.core.common.resources.ResourceLoader;
import com.gollum.core.tools.registered.RegisteredObjects;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import net.minecraft.item.Item;

public class BuildingParser {
    private static final String NAME_IMG = "structure.png";
    private static final String NAME_JSON = "infos.json";
    private static TreeMap<String, Building> parsed = new TreeMap();
    private JdomParser parser = new JdomParser();
    private ResourceLoader resourceLoader = new ResourceLoader();
    private String modID;

    public static TreeMap<String, Building> getBuildingsList() {
        return parsed;
    }

    public static void reloadAll() {
        TreeMap oldParsed = (TreeMap)parsed.clone();
        parsed.clear();
        BuildingParser parser = new BuildingParser();
        for (String modIDName : oldParsed.keySet()) {
            parser.parse(modIDName.substring(modIDName.indexOf(":") + 1), modIDName.substring(0, modIDName.indexOf(":")));
        }
    }

    public Building parse(String name, String modId) {
        if (parsed.containsKey(modId + ":" + name)) {
            return parsed.get(modId + ":" + name);
        }
        this.modID = modId;
        ModGollumCoreLib.log.info("Parse '" + name + "' building in " + modId);
        Building building = new Building(name, modId);
        Hashtable<Integer, Building.Unity> colorBlockIndex = new Hashtable<Integer, Building.Unity>();
        try {
            String[] position3D;
            Map map;
            Map map2;
            Building.Unity unity;
            int color;
            InputStream is = this.resourceLoader.asset("buildings/" + name + "/" + NAME_IMG, this.modID);
            BufferedImage image = ImageIO.read(is);
            is.close();
            InputStream isJson = this.resourceLoader.asset("buildings/" + name + "/" + NAME_JSON, this.modID);
            JsonRootNode json = this.parser.parse((Reader)new InputStreamReader(isJson));
            isJson.close();
            try {
                building.height = Integer.parseInt(json.getNumberValue(new Object[]{"height"}));
            }
            catch (Exception e) {
                // empty catch block
            }
            ModGollumCoreLib.log.debug("Color index  building '" + name + "' load...");
            JsonNode colorLink = json.getNode(new Object[]{"color"});
            for (int y = 0; y < image.getHeight() && (color = image.getRGB(0, y) & 0xFFFFFF) != 0 && color != 0xFFFFFF; ++y) {
                JsonNode type = colorLink.getNode(new Object[]{y});
                Building.Unity unity2 = this.parseBlockDescription(type);
                colorBlockIndex.put(color, unity2);
            }
            ModGollumCoreLib.log.info("Color index  building '" + name + "' loaded");
            boolean slideNum = false;
            int x = 0;
            int y = 0;
            int z = 0;
            int originXSlide = 1;
            while (originXSlide < image.getWidth()) {
                int xImage = originXSlide;
                for (int zImage = 0; zImage < image.getHeight(); ++zImage) {
                    for (xImage = originXSlide; xImage < image.getWidth(); ++xImage) {
                        boolean alpha;
                        int color2 = image.getRGB(xImage, zImage);
                        boolean bl = alpha = image.getTransparency() != 1 && (color2 >> 24 & 0xFF) == 0;
                        if ((color2 &= 0xFFFFFF) == 0 && !alpha) break;
                        unity = null;
                        if (alpha) {
                            building.setNull(x, y, z);
                        } else {
                            Building.Unity unityPtr = null;
                            try {
                                unityPtr = (Building.Unity)colorBlockIndex.get(color2);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            unity = unityPtr != null ? unityPtr : new Building.Unity();
                            building.set(x, y, z, unity);
                        }
                        ++x;
                    }
                    ++z;
                    x = 0;
                }
                originXSlide = xImage + 1;
                ++y;
                z = 0;
            }
            try {
                map2 = json.getNode(new Object[]{"sets"}).getFields();
                for (JsonStringNode key : map2.keySet()) {
                    String[] position3D2 = key.getText().split("x");
                    x = Integer.parseInt(position3D2[0]);
                    y = Integer.parseInt(position3D2[1]);
                    z = Integer.parseInt(position3D2[2]);
                    unity = this.parseBlockDescription((JsonNode)map2.get(key));
                    building.set(x, y, building.maxZ() - z - 1, unity);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                map2 = json.getNode(new Object[]{"buildings"}).getFields();
                for (JsonStringNode key : map2.keySet()) {
                    String[] position3D3 = key.getText().split("x");
                    Building.SubBuilding subBuilding = new Building.SubBuilding();
                    subBuilding.building = this.parse(((JsonNode)map2.get(key)).getText(), modId);
                    subBuilding.x = Integer.parseInt(position3D3[0]);
                    subBuilding.y = Integer.parseInt(position3D3[1]);
                    subBuilding.z = Integer.parseInt(position3D3[2]);
                    building.addBuilding(subBuilding);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                for (JsonNode randomBlock : json.getArrayNode(new Object[]{"random"})) {
                    Building.GroupSubBuildings groupSubBuildings = new Building.GroupSubBuildings();
                    for (JsonNode group : randomBlock.getElements()) {
                        Building.SubBuilding subBuilding = new Building.SubBuilding();
                        map = group.getFields();
                        for (JsonStringNode key : map.keySet()) {
                            position3D = key.getText().split("x");
                            x = Integer.parseInt(position3D[0]);
                            y = Integer.parseInt(position3D[1]);
                            z = Integer.parseInt(position3D[2]);
                            Building.Unity unity3 = this.parseBlockDescription((JsonNode)map.get(key));
                            subBuilding.building.set(x, y, building.maxZ() - z - 1, unity3);
                            subBuilding.synMax(building);
                        }
                        groupSubBuildings.add(subBuilding);
                    }
                    building.addRandomBuildings(groupSubBuildings);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                for (JsonNode randomBlock : json.getArrayNode(new Object[]{"randomBuildings"})) {
                    Building.GroupSubBuildings groupSubBuildings = new Building.GroupSubBuildings();
                    for (JsonNode group : randomBlock.getElements()) {
                        Building.ListSubBuildings listSubBuildings = new Building.ListSubBuildings();
                        map = group.getFields();
                        for (JsonStringNode key : map.keySet()) {
                            position3D = key.getText().split("x");
                            Building.SubBuilding subBuilding = new Building.SubBuilding();
                            subBuilding.x = Integer.parseInt(position3D[0]);
                            subBuilding.y = Integer.parseInt(position3D[1]);
                            subBuilding.z = Integer.parseInt(position3D[2]);
                            subBuilding.building = this.parse(((JsonNode)map.get(key)).getText(), modId);
                            listSubBuildings.add(subBuilding);
                        }
                        groupSubBuildings.add(listSubBuildings);
                    }
                    building.addRandomBuildings(groupSubBuildings);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ModGollumCoreLib.log.info("Matrice building '" + name + "' loaded");
        }
        catch (IOException e) {
            ModGollumCoreLib.log.severe("Error to read resource in jar for building :'" + name + "'");
            return null;
        }
        catch (InvalidSyntaxException e) {
            ModGollumCoreLib.log.severe("Invalid json in jar for building :'" + name + "'");
            return null;
        }
        parsed.put(modId + ":" + name, building);
        return building;
    }

    private Building.Unity parseBlockDescription(JsonNode type) {
        Building.Unity unity = new Building.Unity();
        try {
            String blockStr = type.getStringValue(new Object[]{"block"});
            String metadata = "0";
            try {
                metadata = type.getNumberValue(new Object[]{"metadata"});
            }
            catch (Exception e) {
                // empty catch block
            }
            String orientation = "none";
            try {
                orientation = type.getStringValue(new Object[]{"orientation"});
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean after = false;
            try {
                after = type.getBooleanValue(new Object[]{"after"});
            }
            catch (Exception e) {
                // empty catch block
            }
            JsonNode contents = null;
            try {
                contents = type.getNode(new Object[]{"contents"});
            }
            catch (Exception e) {
                // empty catch block
            }
            unity.block = RegisteredObjects.instance().getBlock(blockStr);
            unity.metadata = Integer.parseInt(metadata);
            unity.after = after;
            if (orientation.equals("none")) {
                unity.orientation = 0;
            } else if (orientation.equals("up")) {
                unity.orientation = 1;
            } else if (orientation.equals("down")) {
                unity.orientation = 2;
            } else if (orientation.equals("left")) {
                unity.orientation = 3;
            } else if (orientation.equals("right")) {
                unity.orientation = 4;
            } else if (orientation.equals("top_vertical")) {
                unity.orientation = 7;
            } else if (orientation.equals("bottom_vertical")) {
                unity.orientation = 8;
            } else if (orientation.equals("top_horizontal")) {
                unity.orientation = 5;
            } else if (orientation.equals("bottom_horizontal")) {
                unity.orientation = 6;
            }
            if (contents != null) {
                unity.contents = new ArrayList();
                for (JsonNode group : contents.getElements()) {
                    unity.contents.add(this.parseContents(group));
                }
            }
            unity.extra = new HashMap();
            try {
                Map map = type.getNode(new Object[]{"extra"}).getFields();
                for (JsonStringNode key : map.keySet()) {
                    unity.extra.put(key.getText(), ((JsonNode)map.get(key)).getText());
                }
            }
            catch (Exception e) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unity;
    }

    private ArrayList<Building.Unity.Content> parseContents(JsonNode group) {
        ArrayList<Building.Unity.Content> contentsGroup = new ArrayList<Building.Unity.Content>();
        for (JsonNode el : group.getElements()) {
            try {
                int type = 0;
                Item item = RegisteredObjects.instance().getItem(el.getStringValue(new Object[]{"element"}));
                Building.Unity.Content content = new Building.Unity.Content();
                content.item = item;
                content.type = type;
                content.min = 1;
                try {
                    content.min = Integer.parseInt(el.getNumberValue(new Object[]{"min"}));
                }
                catch (Exception e) {
                    // empty catch block
                }
                content.max = 1;
                try {
                    content.max = Integer.parseInt(el.getNumberValue(new Object[]{"max"}));
                }
                catch (Exception e) {
                    // empty catch block
                }
                content.metadata = -1;
                try {
                    content.metadata = Integer.parseInt(el.getNumberValue(new Object[]{"metadata"}));
                }
                catch (Exception e) {
                    // empty catch block
                }
                contentsGroup.add(content);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return contentsGroup;
    }
}

