/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.tileentities;

import com.gollum.castledefenders.ModCastleDefenders;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class TileEntityBlockCastleDefenders
extends TileEntity
implements ITickable {
    public int delay = 20;
    protected int minSpawnDelay = 200;
    protected int maxSpawnDelay = 800;
    private int maxSpawn = 0;
    private List<Integer> entitiesSpawned = new ArrayList<Integer>();
    private String mobID;

    public TileEntityBlockCastleDefenders(String mobID, int maxSpawn) {
        this.mobID = mobID;
        this.maxSpawn = maxSpawn;
    }

    public String getMobID() {
        return this.mobID;
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 16.0, false) != null;
    }

    private void updateDelay() {
        this.delay = this.minSpawnDelay + this.field_145850_b.field_73012_v.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
    }

    public void func_73660_a() {
        if (this.anyPlayerInRange() && !this.field_145850_b.field_72995_K) {
            ArrayList<Integer> entitiesSpawnedCopy = new ArrayList<Integer>(this.entitiesSpawned);
            for (Integer entityId : entitiesSpawnedCopy) {
                Entity entity = this.field_145850_b.func_73045_a(entityId.intValue());
                if (entity != null) {
                    if (!entity.field_70128_L) continue;
                    this.entitiesSpawned.remove(entityId);
                    ModCastleDefenders.logger.debug(new Object[]{"Entity is dead: ", entityId});
                    continue;
                }
                this.entitiesSpawned.remove(entityId);
                ModCastleDefenders.logger.debug(new Object[]{"Entity not found: ", entityId});
            }
            if (this.delay == -1) {
                this.updateDelay();
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            if (this.entitiesSpawned.size() >= this.maxSpawn) {
                this.updateDelay();
                return;
            }
            Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.mobID), (World)this.field_145850_b);
            if (entity == null) {
                ModCastleDefenders.logger.warning(new Object[]{"This mob " + this.mobID + " isn't  register"});
                return;
            }
            int nbEntityArround = this.field_145850_b.func_72872_a(entity.getClass(), new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72321_a(12.0, 4.0, 12.0)).size();
            if (nbEntityArround >= this.maxSpawn) {
                this.updateDelay();
                return;
            }
            double x = (double)this.field_174879_c.func_177958_n() + 0.5;
            double y = this.field_174879_c.func_177956_o() + 1;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5;
            EntityLiving entityLiving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
            entity.func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, this.field_145850_b.field_73012_v.nextFloat() * 360.0f);
            if (entityLiving != null && entityLiving.func_70601_bi()) {
                this.entitiesSpawned.add(entity.func_145782_y());
                this.field_145850_b.func_72838_d(entity);
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.6f);
                if (entityLiving != null) {
                    entityLiving.func_70656_aK();
                }
                this.updateDelay();
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        int[] entitiesId;
        super.func_145839_a(nbt);
        this.delay = nbt.func_74765_d("delay");
        int[] nArray = entitiesId = nbt.func_74759_k("entitiesSpawned");
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer id = nArray[i];
            if (this.entitiesSpawned.contains(id)) continue;
            this.entitiesSpawned.add(id);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("delay", (short)this.delay);
        int size = this.entitiesSpawned.size();
        int[] entitiesId = new int[size];
        for (int i = 0; i < size; ++i) {
            entitiesId[0] = this.entitiesSpawned.get(i);
        }
        nbt.func_74783_a("entitiesSpawned", entitiesId);
        return nbt;
    }
}

