/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.ModCastleDefenders;
import com.gollum.castledefenders.common.entities.ICastleEntity;
import com.gollum.core.common.config.type.ItemStackConfigType;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMercenary
extends EntityTameable
implements ICastleEntity {
    private static final DataParameter<String> OWNERLIST = EntityDataManager.func_187226_a(EntityTameable.class, (DataSerializer)DataSerializers.field_187194_d);
    protected Block blockSpawn;
    private int idTask = 0;
    private int idTargetTask = 0;
    private int eating = -1;
    private int autoHeal = 0;

    public EntityMercenary(World world) {
        super(world);
        this.func_70105_a(1.1f, 1.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        ((PathNavigateGround)this.func_70661_as()).func_179691_c(true);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNERLIST, (Object)"");
    }

    protected void func_184651_r() {
        float follow = Math.min((float)(this.getFollowRange() - 1.0), 10.0f);
        if (follow < 1.0f) {
            follow = 1.0f;
        }
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, this.getMaxSpeed(), follow, 1.0f));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    public int nextIdTask() {
        return this.idTask++;
    }

    public int nextIdTargetTask() {
        return this.idTargetTask++;
    }

    protected double getMinSpeed() {
        return 0.0;
    }

    protected double getMaxSpeed() {
        return this.getCapacities().moveSpeed;
    }

    @Override
    public double getMoveSpeed() {
        return this.func_70909_n() ? this.getMaxSpeed() : this.getMinSpeed();
    }

    @Override
    public double getMaxHealt() {
        return this.getCapacities().maxHealt;
    }

    @Override
    public double getAttackStrength() {
        return this.getCapacities().attackStrength;
    }

    @Override
    public double getFollowRange() {
        return this.getCapacities().followRange;
    }

    @Override
    public double getTimeRange() {
        return this.getCapacities().timeRange;
    }

    protected abstract MobCapacitiesConfigType getCapacities();

    protected abstract ItemStackConfigType[] getCost();

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.autoHeal % 50 == 0) {
                this.func_70691_i(0.5f);
                this.autoHeal = 0;
            }
            ++this.autoHeal;
        }
    }

    private void setOwnerListString(String ownerList) {
        this.field_70180_af.func_187227_b(OWNERLIST, (Object)ownerList);
    }

    private String getOwnerListString() {
        return (String)this.field_70180_af.func_187225_a(OWNERLIST);
    }

    private ArrayList<String> getOwnerList() {
        String strOwnerList = this.getOwnerListString();
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, strOwnerList.split(","));
        return list;
    }

    private void addInOwnerList(String ownerId) {
        ArrayList<String> list = this.getOwnerList();
        list.add(ownerId);
        this.setOwnerListString(String.join((CharSequence)",", list));
    }

    @SideOnly(value=Side.CLIENT)
    public String getMessagePlayer() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            if (player.func_110124_au() != null && this.getOwnerList().contains(player.func_110124_au().toString())) {
                return ModCastleDefenders.i18n.trans("message.wait_here", new Object[0]);
            }
            ItemStack stack = null;
            stack = this.hasBuyItemInHand((EntityPlayer)player);
            if (stack != null) {
                return ModCastleDefenders.i18n.trans("message.okfor", new Object[]{stack.func_190916_E(), stack.func_82833_r()});
            }
        }
        return ModCastleDefenders.i18n.trans("message.buymercenary", new Object[0]);
    }

    public ItemStack hasBuyItemInHand(EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item != null) {
            if (this.getCapacities() == null) {
                return null;
            }
            for (ItemStackConfigType config : this.getCost()) {
                ItemStack cStack = config.getItemStak();
                if (cStack.func_77973_b() != item.func_77973_b()) continue;
                return cStack;
            }
        }
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    protected void func_70908_e(boolean var1) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> var1) {
        return EntityGhast.class != var1 && !EntityMercenary.class.isAssignableFrom(var1);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70641_bl() {
        return 6;
    }

    public boolean func_70601_bi() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState stateBlock = this.field_70170_p.func_180495_p(pos.func_177977_b());
        IBlockState stateUp1 = this.field_70170_p.func_180495_p(pos);
        IBlockState stateUp2 = this.field_70170_p.func_180495_p(pos.func_177984_a());
        List entityListBlockArround = this.field_70170_p.func_72872_a(this.getClass(), new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72321_a(2.0, 2.0, 2.0));
        boolean found = false;
        for (Object arroundEntity : entityListBlockArround) {
            if (arroundEntity.getClass() != this.getClass()) continue;
            found = true;
        }
        return !(stateBlock.func_177230_c() != this.blockSpawn || stateUp1 != null && !(stateUp1.func_177230_c() instanceof BlockAir) && stateUp1.func_177230_c().func_149703_v() || stateUp2 != null && !(stateUp2.func_177230_c() instanceof BlockAir) && stateUp2.func_177230_c().func_149703_v() || found);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.eating >= 0) {
            if (this.eating % 4 == 0) {
                this.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            ++this.eating;
            if (this.eating == 10) {
                this.eating = -1;
            }
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public boolean func_70097_a(DamageSource damageSource, float strength) {
        Entity entity;
        if (super.func_70097_a(damageSource, strength) && this.func_184196_w(entity = damageSource.func_76364_f()) && this.func_184187_bx().equals((Object)entity) && entity != this && entity instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)entity);
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        double strength = this.getAttackStrength();
        if (this.func_70644_a(MobEffects.field_76420_g)) {
            strength += (double)(3 << this.func_70660_b(MobEffects.field_76420_g).func_76458_c());
        }
        if (this.func_70644_a(MobEffects.field_76437_t)) {
            strength -= (double)(2 << this.func_70660_b(MobEffects.field_76437_t).func_76458_c());
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)strength);
    }

    private boolean buy(EntityPlayer player, Class<ItemFood> itemClass, int nb) {
        return this.buy(player, null, itemClass, nb);
    }

    private boolean buy(EntityPlayer player, Item item, int nb) {
        return this.buy(player, item, null, nb);
    }

    private boolean buy(EntityPlayer player, Item item, Class<ItemFood> itemClass, int nb) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is != null && is.func_190916_E() >= nb && (itemClass != null && itemClass.isInstance(is.func_77973_b()) || item != null && is.func_77973_b() == item)) {
            if (!player.field_71075_bZ.field_75098_d) {
                is.func_190920_e(is.func_190916_E() - nb);
            }
            if (is.func_190916_E() <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
            return true;
        }
        return false;
    }

    private void linkOwner(EntityPlayer player) {
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        this.field_70703_bu = false;
        if (player != null) {
            this.func_70903_f(true);
            this.func_184754_b(player.func_110124_au());
            if (!this.getOwnerList().contains(player.func_110124_au().toString())) {
                this.addInOwnerList(player.func_110124_au().toString());
            }
        } else {
            this.func_70903_f(false);
            this.func_184754_b(null);
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is != null && is.func_77973_b() instanceof ItemSplashPotion) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            if (!this.func_70909_n()) {
                boolean buy = this.isAlraidyBuy(player);
                if (!buy) {
                    ItemStackConfigType stackConfig;
                    ItemStack stack;
                    ItemStackConfigType[] itemStackConfigTypeArray = this.getCost();
                    int n = itemStackConfigTypeArray.length;
                    for (int i = 0; i < n && !(buy = this.buy(player, (stack = (stackConfig = itemStackConfigTypeArray[i]).getItemStak()).func_77973_b(), stack.func_190916_E())); ++i) {
                    }
                }
                if (buy) {
                    this.linkOwner(player);
                    return true;
                }
            } else if (this.func_152114_e((EntityLivingBase)player)) {
                if (this.buy(player, ItemFood.class, 1)) {
                    ItemFood food = (ItemFood)is.func_77973_b();
                    this.func_70691_i(food.func_150905_g(is));
                    this.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    this.eating = 0;
                    return true;
                }
                this.linkOwner(null);
                return true;
            }
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    public boolean isAlraidyBuy(EntityPlayer player) {
        return this.getOwnerList().contains(player.func_110124_au().toString());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isOwner() {
        return this.func_152114_e((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
    }

    public boolean func_152114_e(EntityLivingBase player) {
        return this.func_184753_b() != null && this.func_184753_b().equals(player.func_110124_au());
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("ownerList", this.getOwnerListString());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setOwnerListString(nbt.func_74779_i("ownerList"));
    }
}

