/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.ModCastleDefenders;
import com.gollum.castledefenders.common.entities.EntityMercenary;
import com.gollum.castledefenders.inits.ModBlocks;
import com.gollum.castledefenders.inits.ModSounds;
import com.gollum.core.common.config.type.ItemStackConfigType;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityHealer
extends EntityMercenary {
    private static final int maxCouldDownMusic = 300;
    int couldDown = 0;
    int couldDownMusic = 300;

    public EntityHealer(World world) {
        super(world);
        this.blockSpawn = ModBlocks.HEALER;
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151122_aG, 1));
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAIWander((EntityCreature)this, this.getMaxSpeed()));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected MobCapacitiesConfigType getCapacities() {
        return ModCastleDefenders.config.healerCapacities;
    }

    @Override
    protected ItemStackConfigType[] getCost() {
        return ModCastleDefenders.config.healerCost;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if ((double)this.couldDown > this.getTimeRange()) {
            this.healEntitiesNearby();
        } else {
            ++this.couldDown;
        }
        if (this.couldDownMusic <= 300) {
            ++this.couldDownMusic;
        }
    }

    private void healEntitiesNearby() {
        List entitiesNearby = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - this.getFollowRange(), this.field_70163_u - this.getFollowRange(), this.field_70161_v - this.getFollowRange(), this.field_70165_t + this.getFollowRange(), this.field_70163_u + this.getFollowRange(), this.field_70161_v + this.getFollowRange()));
        for (EntityPlayer player : entitiesNearby) {
            if (!this.func_152114_e((EntityLivingBase)player) || player.func_110143_aJ() == player.func_110138_aP()) continue;
            if (this.couldDownMusic > 300) {
                this.couldDownMusic = 0;
                this.func_184185_a(ModSounds.MONK, 0.1f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.3f);
            }
            ModCastleDefenders.logger.debug(new Object[]{"Heal player"});
            player.func_70691_i(ModCastleDefenders.config.healPointByTimeRange);
            this.couldDown = 0;
        }
    }
}

