/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.ModCastleDefenders;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFireBall
extends Entity {
    public EntityLivingBase shooter = null;
    public double oriX = 0.0;
    public double oriY = 0.0;
    public double oriZ = 0.0;
    public double directionX = 0.0;
    public double directionY = 0.0;
    public double directionZ = 0.0;
    public float damage = 2.0f;

    public EntityFireBall(World worldIn) {
        super(worldIn);
    }

    public EntityFireBall(World worldIn, EntityLivingBase shooter, Entity target) {
        this(worldIn, shooter, target.field_70165_t, target.field_70163_u, target.field_70161_v);
    }

    public EntityFireBall(World worldIn, EntityLivingBase shooter, double x, double y, double z) {
        super(worldIn);
        this.field_70130_N = 0.4f;
        this.field_70131_O = 0.4f;
        this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        this.shooter = shooter;
        this.oriX = this.field_70165_t;
        this.oriY = this.field_70163_u;
        this.oriZ = this.field_70161_v;
        Vec3d vec3 = new Vec3d(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v).func_72432_b().func_186678_a(0.5);
        this.directionX += vec3.field_72450_a;
        this.directionY += vec3.field_72448_b;
        this.directionZ += vec3.field_72449_c;
        if (this.directionX == 0.0 && this.directionY == 0.0 && this.directionZ == 0.0) {
            ModCastleDefenders.logger.debug(new Object[]{"Fireball not move"});
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K || (this.shooter == null || !this.shooter.field_70128_L) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K && this.distanceRunning() > 20.0) {
                this.func_70106_y();
                return;
            }
            RayTraceResult raytraceresult = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (boolean)false, (Entity)this.shooter);
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onImpact(raytraceresult);
                return;
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float motionFactor = 1.0f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                motionFactor = 0.7f;
            }
            this.field_70159_w = this.directionX * (double)motionFactor;
            this.field_70181_x = this.directionY * (double)motionFactor;
            this.field_70179_y = this.directionZ * (double)motionFactor;
            this.field_70170_p.func_175688_a(this.getParticleType(), this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else {
            this.func_70106_y();
        }
    }

    protected double distanceRunning() {
        return new Vec3d(this.oriX, this.oriY, this.oriZ).func_72438_d(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
    }

    protected void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            if (result.field_72308_g != null) {
                if (!result.field_72308_g.func_70045_F()) {
                    DamageSource damageSource = new EntityDamageSourceIndirect("onFire", (Entity)this, (Entity)(this.shooter != null ? this.shooter : this)).func_76361_j().func_76349_b();
                    this.func_174815_a(this.shooter, result.field_72308_g);
                    result.field_72308_g.func_70015_d(1);
                    result.field_72308_g.func_70097_a(damageSource, this.damage);
                    result.field_72308_g.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 0.6f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                }
            } else {
                BlockPos blockpos;
                boolean flag1 = true;
                if (this.shooter != null && this.shooter instanceof EntityLiving) {
                    flag1 = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shooter);
                }
                if (flag1 && this.field_70170_p.func_175623_d(blockpos = result.func_178782_a().func_177972_a(result.field_178784_b))) {
                    this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.SMOKE_NORMAL;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.oriX = compound.func_74769_h("oriX");
        this.oriY = compound.func_74769_h("oriY");
        this.oriZ = compound.func_74769_h("oriZ");
        this.directionX = compound.func_74769_h("directionX");
        this.directionY = compound.func_74769_h("directionY");
        this.directionZ = compound.func_74769_h("directionZ");
        this.damage = compound.func_74760_g("damage");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74780_a("oriX", this.oriX);
        compound.func_74780_a("oriY", this.oriY);
        compound.func_74780_a("oriZ", this.oriZ);
        compound.func_74780_a("directionX", this.directionX);
        compound.func_74780_a("directionY", this.directionY);
        compound.func_74780_a("directionZ", this.directionZ);
        compound.func_74776_a("damage", this.damage);
    }
}

