/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.common.entities.EntityDefender;
import com.gollum.castledefenders.common.entities.EntityMercenary;
import com.gollum.castledefenders.common.entities.ICastleEntity;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityEnemy
extends EntityMob
implements ICastleEntity {
    protected Block blockSpawn;
    private int idTask = 0;
    private int idTargetTask = 0;

    public EntityEnemy(World world) {
        super(world);
        this.func_70105_a(1.1f, 1.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        ((PathNavigateGround)this.func_70661_as()).func_179691_c(true);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getAttackStrength());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAIWander((EntityCreature)this, this.getMoveSpeed()));
        this.field_70715_bh.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                return entity instanceof EntityPlayer || entity instanceof EntityDefender || entity instanceof EntityMercenary || entity instanceof EntityIronGolem;
            }
        }));
    }

    public int nextIdTask() {
        return this.idTask++;
    }

    public int nextIdTargetTask() {
        return this.idTargetTask++;
    }

    @Override
    public double getMoveSpeed() {
        return this.getCapacities().moveSpeed;
    }

    @Override
    public double getMaxHealt() {
        return this.getCapacities().maxHealt;
    }

    @Override
    public double getAttackStrength() {
        return this.getCapacities().attackStrength;
    }

    @Override
    public double getFollowRange() {
        return this.getCapacities().followRange;
    }

    @Override
    public double getTimeRange() {
        return this.getCapacities().timeRange;
    }

    protected abstract MobCapacitiesConfigType getCapacities();

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getAttackStrength());
    }

    protected int getDropItemId() {
        return 0;
    }

    public boolean func_70601_bi() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState stateBlock = this.field_70170_p.func_180495_p(pos.func_177977_b());
        IBlockState stateUp1 = this.field_70170_p.func_180495_p(pos);
        IBlockState stateUp2 = this.field_70170_p.func_180495_p(pos.func_177984_a());
        List entityListBlockArround = this.field_70170_p.func_72872_a(this.getClass(), new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72321_a(2.0, 2.0, 2.0));
        boolean found = false;
        for (Object arroundEntity : entityListBlockArround) {
            if (arroundEntity.getClass() != this.getClass()) continue;
            found = true;
        }
        return !(stateBlock.func_177230_c() != this.blockSpawn || stateUp1 != null && !(stateUp1.func_177230_c() instanceof BlockAir) && stateUp1.func_177230_c().func_149703_v() || stateUp2 != null && !(stateUp2.func_177230_c() instanceof BlockAir) && stateUp2.func_177230_c().func_149703_v() || found);
    }
}

