/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.common.entities.ICastleEntity;
import com.gollum.castledefenders.inits.ModItems;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityDefender
extends EntityAnimal
implements ICastleEntity {
    protected Block blockSpawn;
    private int idTask = 0;
    private int idTargetTask = 0;

    public EntityDefender(World world) {
        super(world);
        this.func_70105_a(1.1f, 1.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        ((PathNavigateGround)this.func_70661_as()).func_179691_c(true);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)0.35f, ModItems.MEDALLION, false));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAIWander((EntityCreature)this, this.getMoveSpeed()));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[]{EntityPlayer.class}));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                return entity instanceof IMob;
            }
        }));
    }

    public int nextIdTask() {
        return this.idTask++;
    }

    public int nextIdTargetTask() {
        return this.idTargetTask++;
    }

    @Override
    public double getMoveSpeed() {
        return this.getCapacities().moveSpeed;
    }

    @Override
    public double getMaxHealt() {
        return this.getCapacities().maxHealt;
    }

    @Override
    public double getAttackStrength() {
        return this.getCapacities().attackStrength;
    }

    @Override
    public double getFollowRange() {
        return this.getCapacities().followRange;
    }

    @Override
    public double getTimeRange() {
        return this.getCapacities().timeRange;
    }

    protected abstract MobCapacitiesConfigType getCapacities();

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
    }

    public boolean func_70097_a(DamageSource damageSource, float strength) {
        Entity entity;
        if (super.func_70097_a(damageSource, strength) && this.func_184196_w(entity = damageSource.func_76364_f()) && this.func_184187_bx().equals((Object)entity) && entity != this && entity instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)entity);
            return true;
        }
        return false;
    }

    public boolean func_70686_a(Class entityClass) {
        return EntityGhast.class != entityClass;
    }

    public boolean func_70652_k(Entity entity) {
        double strength = this.getAttackStrength();
        if (this.func_70644_a(MobEffects.field_76420_g)) {
            strength += (double)(3 << this.func_70660_b(MobEffects.field_76420_g).func_76458_c());
        }
        if (this.func_70644_a(MobEffects.field_76437_t)) {
            strength -= (double)(2 << this.func_70660_b(MobEffects.field_76437_t).func_76458_c());
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)strength);
    }

    public boolean func_70601_bi() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState stateBlock = this.field_70170_p.func_180495_p(pos.func_177977_b());
        IBlockState stateUp1 = this.field_70170_p.func_180495_p(pos);
        IBlockState stateUp2 = this.field_70170_p.func_180495_p(pos.func_177984_a());
        List entityListBlockArround = this.field_70170_p.func_72872_a(this.getClass(), new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72321_a(2.0, 2.0, 2.0));
        boolean found = false;
        for (Object arroundEntity : entityListBlockArround) {
            if (arroundEntity.getClass() != this.getClass()) continue;
            found = true;
        }
        return !(stateBlock.func_177230_c() != this.blockSpawn || stateUp1 != null && !(stateUp1.func_177230_c() instanceof BlockAir) && stateUp1.func_177230_c().func_149703_v() || stateUp2 != null && !(stateUp2.func_177230_c() instanceof BlockAir) && stateUp2.func_177230_c().func_149703_v() || found);
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }
}

