/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.aientities;

import com.gollum.castledefenders.ModCastleDefenders;
import com.gollum.castledefenders.common.entities.EntityFireBall;
import com.gollum.castledefenders.common.entities.ICastleEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIDistanceAttack
extends EntityAIBase {
    World world;
    EntityLiving entityHost;
    EntityLivingBase attackTarget;
    double rangedAttackTime = 0.0;
    double rangedAttackDistance = 0.0;
    double entityMoveSpeed = 0.0;
    double maxRangedAttackTime = 10.0;
    int nbTarget = 0;
    PROJECTILE_TYPE projectileType;

    public EntityAIDistanceAttack(EntityLiving entityLiving, double entityMoveSpeed, double rangedAttackDistance, double rangedAttackTime, PROJECTILE_TYPE projectileType) {
        this.entityHost = entityLiving;
        this.world = entityLiving.field_70170_p;
        this.entityMoveSpeed = entityMoveSpeed;
        this.rangedAttackDistance = rangedAttackDistance;
        this.maxRangedAttackTime = rangedAttackTime;
        this.projectileType = projectileType;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.entityHost.func_70638_az();
        if (target == null) {
            return false;
        }
        this.attackTarget = target;
        return true;
    }

    public boolean continueExecuting() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
    }

    public void func_75246_d() {
        double distance = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        boolean canSeeEntity = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.nbTarget = canSeeEntity ? ++this.nbTarget : 0;
        if (this.nbTarget >= 20) {
            this.entityHost.func_70661_as().func_75499_g();
        } else {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, (float)this.rangedAttackDistance, (float)this.rangedAttackDistance);
        this.rangedAttackTime = Math.max(this.rangedAttackTime - 1.0, 0.0);
        if (this.rangedAttackTime <= 0.0 && canSeeEntity) {
            ModCastleDefenders.logger.debug(new Object[]{"updateTask : rangedAttackTime=" + this.rangedAttackTime});
            this.doRangedAttack();
            this.rangedAttackTime = this.maxRangedAttackTime;
        }
    }

    private void doRangedAttack() {
        Random random = new Random();
        switch (this.projectileType) {
            default: {
                EntityTippedArrow eArrow = new EntityTippedArrow(this.world, (EntityLivingBase)this.entityHost);
                if (this.entityHost instanceof ICastleEntity) {
                    eArrow.func_70239_b(((ICastleEntity)this.entityHost).getAttackStrength());
                }
                double d0 = this.attackTarget.field_70165_t - this.entityHost.field_70165_t;
                double d1 = this.attackTarget.func_174813_aQ().field_72338_b + (double)(this.attackTarget.field_70131_O / 3.0f) - eArrow.field_70163_u;
                double d2 = this.attackTarget.field_70161_v - this.entityHost.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                eArrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.world.func_175659_aa().func_151525_a() * 4));
                this.entityHost.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                this.world.func_72838_d((Entity)eArrow);
                break;
            }
            case FIRE: {
                ModCastleDefenders.logger.debug(new Object[]{"Attack Fire"});
                EntityFireBall eFireball = new EntityFireBall(this.world, (EntityLivingBase)this.entityHost, (Entity)this.attackTarget);
                if (this.entityHost instanceof ICastleEntity) {
                    eFireball.damage = (float)((ICastleEntity)this.entityHost).getAttackStrength();
                }
                this.entityHost.func_184185_a(SoundEvents.field_187754_de, 0.6f, 0.8f + random.nextFloat() * 0.2f);
                this.world.func_72838_d((Entity)eFireball);
            }
        }
    }

    public static enum PROJECTILE_TYPE {
        ARROW,
        FIRE;

    }
}

