/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.ModCastleDefenders;
import com.gollum.core.common.config.type.ItemStackConfigType;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityMercenary
extends EntityTameable {
    protected ItemStack defaultHeldItem = null;
    protected Block blockSpawn;
    private int idTask = 0;
    private int idTargetTask = 0;
    private ArrayList<String> ownerList = new ArrayList();
    private int eating = -1;

    public EntityMercenary(World world) {
        super(world);
        this.func_70105_a(1.1f, 1.8f);
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75491_a(false);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
        float follow = Math.min((float)(this.getFollowRange() - 1.0), 10.0f);
        if (follow < 1.0f) {
            follow = 1.0f;
        }
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, this.getMaxSpeed(), follow, 1.0f));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, IMob.class, 200, false));
        this.field_70715_bh.func_75776_a(this.nextIdTargetTask(), (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, IMob.class, 0, true));
    }

    public int nextIdTask() {
        return this.idTask++;
    }

    public int nextIdTargetTask() {
        return this.idTargetTask++;
    }

    protected double getMinSpeed() {
        return 0.0;
    }

    protected double getMaxSpeed() {
        return this.getCapacities().moveSpeed;
    }

    protected double getMoveSpeed() {
        return this.func_70909_n() ? this.getMaxSpeed() : this.getMinSpeed();
    }

    protected double getMaxHealt() {
        return this.getCapacities().maxHealt;
    }

    protected double getAttackStrength() {
        return this.getCapacities().attackStrength;
    }

    protected double getFollowRange() {
        return this.getCapacities().followRange;
    }

    protected double getTimeRange() {
        return this.getCapacities().timeRange;
    }

    protected abstract MobCapacitiesConfigType getCapacities();

    protected abstract ItemStackConfigType[] getCost();

    @SideOnly(value=Side.CLIENT)
    public String getMessagePlayer() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = null;
        stack = this.hasBuyItemInHand((EntityPlayer)player);
        if (stack != null) {
            return ModCastleDefenders.i18n.trans("message.okfor", new Object[]{stack.field_77994_a, stack.func_82833_r()});
        }
        return ModCastleDefenders.i18n.trans("message.buymercenary", new Object[0]);
    }

    public ItemStack hasBuyItemInHand(EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item != null) {
            if (this.getCapacities() == null) {
                return null;
            }
            for (ItemStackConfigType config : this.getCost()) {
                ItemStack cStack = config.getItemStak();
                if (cStack.func_77973_b() != item.func_77973_b()) continue;
                return cStack;
            }
        }
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70629_bd() {
        this.field_70180_af.func_75692_b(18, (Object)new Integer((int)this.func_110143_aJ()));
    }

    protected void func_70908_e(boolean var1) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Integer((int)this.func_110143_aJ()));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        int i = 0;
        for (String owner : this.ownerList) {
            nbt.func_74778_a("owner" + i, owner);
            ModCastleDefenders.log.debug(new Object[]{"Write owner" + i + " : " + owner});
            ++i;
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        int i = 0;
        this.ownerList.clear();
        String owner = null;
        do {
            owner = null;
            try {
                owner = nbt.func_74779_i("owner" + i);
            }
            catch (Exception e) {
                owner = null;
            }
            if (owner != null && !owner.equals("") && !this.ownerList.contains(owner)) {
                ModCastleDefenders.log.debug(new Object[]{"Read NBT merc owner: " + owner});
                this.ownerList.add(owner);
            }
            ++i;
        } while (owner != null && !owner.equals(""));
    }

    public boolean func_70686_a(Class var1) {
        return EntityGhast.class != var1 && !EntityMercenary.class.isAssignableFrom(var1);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_70601_bi() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        Block block = this.field_70170_p.func_147439_a(x, y - 1, z);
        Block up1 = this.field_70170_p.func_147439_a(x, y, z);
        Block up2 = this.field_70170_p.func_147439_a(x, y + 1, z);
        List entityListBlockArround = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)).func_72314_b(2.0, 2.0, 2.0));
        boolean found = false;
        for (Object arroundEntity : entityListBlockArround) {
            if (arroundEntity.getClass() != ((Object)((Object)this)).getClass()) continue;
            found = true;
        }
        return !(block != this.blockSpawn || up1 != null && !(up1 instanceof BlockAir) && up1.func_149703_v() || up2 != null && !(up2 instanceof BlockAir) && up2.func_149703_v() || found);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            EntityClientPlayerMP entityClientPlayerMP = Minecraft.func_71410_x().field_71439_g;
        }
        if (this.eating >= 0) {
            if (this.eating % 4 == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "random.eat", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            ++this.eating;
            if (this.eating == 10) {
                this.eating = -1;
            }
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected void func_70785_a(Entity entity, float var2) {
        if (this.field_70724_aR <= 0 && var2 < 2.0f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 10;
            this.func_70652_k(entity);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float strength) {
        if (super.func_70097_a(damageSource, strength)) {
            Entity entity = damageSource.func_76346_g();
            if (this.field_70153_n != entity && this.field_70154_o != entity) {
                if (entity != this) {
                    this.field_70789_a = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        double strength = this.getAttackStrength();
        if (this.func_70644_a(Potion.field_76420_g)) {
            strength += (double)(3 << this.func_70660_b(Potion.field_76420_g).func_76458_c());
        }
        if (this.func_70644_a(Potion.field_76437_t)) {
            strength -= (double)(2 << this.func_70660_b(Potion.field_76437_t).func_76458_c());
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)strength);
    }

    private boolean buy(EntityPlayer player, Class itemClass, int nb) {
        return this.buy(player, null, itemClass, nb);
    }

    private boolean buy(EntityPlayer player, Item item, int nb) {
        return this.buy(player, item, null, nb);
    }

    private boolean buy(EntityPlayer player, Item item, Class itemClass, int nb) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is != null && is.field_77994_a >= nb && (itemClass != null && itemClass.isInstance(is.func_77973_b()) || item != null && is.func_77973_b() == item)) {
            if (!player.field_71075_bZ.field_75098_d) {
                is.field_77994_a -= nb;
            }
            if (is.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
            return true;
        }
        return false;
    }

    private void linkOwner(EntityPlayer player) {
        this.func_70778_a(null);
        this.func_70624_b(null);
        this.field_70703_bu = false;
        if (player != null) {
            this.func_70903_f(true);
            this.func_70910_a(player.func_110124_au().toString());
            if (!this.ownerList.contains(player.func_110124_au().toString())) {
                this.ownerList.add(player.func_110124_au().toString());
            }
        } else {
            this.func_70903_f(false);
            this.func_70910_a("");
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.func_70909_n()) {
                boolean buy = this.isAlraidyBuy(player);
                if (!buy) {
                    ItemStackConfigType stackConfig;
                    ItemStack stack;
                    ItemStackConfigType[] arr$ = this.getCost();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && !(buy = this.buy(player, (stack = (stackConfig = arr$[i$]).getItemStak()).func_77973_b(), stack.field_77994_a)); ++i$) {
                    }
                }
                if (buy) {
                    this.linkOwner(player);
                    return true;
                }
            } else if (this.func_70905_p().equals(player.func_110124_au().toString())) {
                ModCastleDefenders.log.debug(new Object[]{"Interract with owner: " + player.func_70005_c_()});
                if (this.buy(player, ItemFood.class, 1)) {
                    ItemFood food = (ItemFood)is.func_77973_b();
                    this.func_70691_i(food.func_150905_g(is));
                    this.field_70170_p.func_72956_a((Entity)this, "random.eat", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    this.eating = 0;
                    return true;
                }
                this.linkOwner(null);
                return true;
            }
        }
        return false;
    }

    public ItemStack func_70694_bm() {
        if (this.defaultHeldItem == null) {
            return super.func_70694_bm();
        }
        return this.defaultHeldItem;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    public boolean isAlraidyBuy(EntityPlayer player) {
        return this.ownerList.contains(player.func_110124_au().toString());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isOwner() {
        return this.isOwner((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public boolean isOwner(EntityPlayer player) {
        return this.func_70905_p().equals(player.func_110124_au().toString());
    }
}

