/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.inits.ModItems;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityDefender
extends EntityAnimal {
    protected ItemStack defaultHeldItem = null;
    protected Block blockSpawn;
    private int idTask = 0;
    private int idTargetTask = 0;

    public EntityDefender(World world) {
        super(world);
        this.func_70105_a(1.1f, 1.8f);
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75491_a(true);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)0.35f, ModItems.itemMedallion, false));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(this.nextIdTask(), (EntityAIBase)new EntityAIWander((EntityCreature)this, this.getMoveSpeed()));
    }

    public int nextIdTask() {
        return this.idTask++;
    }

    public int nextIdTargetTask() {
        return this.idTargetTask++;
    }

    protected double getMoveSpeed() {
        return this.getCapacities().moveSpeed;
    }

    protected double getMaxHealt() {
        return this.getCapacities().maxHealt;
    }

    protected double getAttackStrength() {
        return this.getCapacities().attackStrength;
    }

    protected double getFollowRange() {
        return this.getCapacities().followRange;
    }

    protected double getTimeRange() {
        return this.getCapacities().timeRange;
    }

    protected abstract MobCapacitiesConfigType getCapacities();

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealt());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getFollowRange());
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70785_a(Entity entity, float var2) {
        if (this.field_70724_aR <= 0 && var2 < 2.0f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 10;
            this.func_70652_k(entity);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float strength) {
        if (super.func_70097_a(damageSource, strength)) {
            Entity entity = damageSource.func_76346_g();
            if (this.field_70153_n != entity && this.field_70154_o != entity) {
                if (entity != this) {
                    this.field_70789_a = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_70686_a(Class entityClass) {
        return EntityGhast.class != entityClass;
    }

    public boolean func_70652_k(Entity entity) {
        double strength = this.getAttackStrength();
        if (this.func_70644_a(Potion.field_76420_g)) {
            strength += (double)(3 << this.func_70660_b(Potion.field_76420_g).func_76458_c());
        }
        if (this.func_70644_a(Potion.field_76437_t)) {
            strength -= (double)(2 << this.func_70660_b(Potion.field_76437_t).func_76458_c());
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)strength);
    }

    public boolean func_70601_bi() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        Block block = this.field_70170_p.func_147439_a(x, y - 1, z);
        Block up1 = this.field_70170_p.func_147439_a(x, y, z);
        Block up2 = this.field_70170_p.func_147439_a(x, y + 1, z);
        List entityListBlockArround = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)).func_72314_b(2.0, 2.0, 2.0));
        boolean found = false;
        for (Object arroundEntity : entityListBlockArround) {
            if (arroundEntity.getClass() != ((Object)((Object)this)).getClass()) continue;
            found = true;
        }
        return !(block != this.blockSpawn || up1 != null && !(up1 instanceof BlockAir) && up1.func_149703_v() || up2 != null && !(up2 instanceof BlockAir) && up2.func_149703_v() || found);
    }

    public ItemStack func_70694_bm() {
        if (this.defaultHeldItem == null) {
            return super.func_70694_bm();
        }
        return this.defaultHeldItem;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }
}

