/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.aientities;

import com.gollum.castledefenders.ModCastleDefenders;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityAIDistanceAttack
extends EntityAIBase {
    public static final int TYPE_ARROW = 0;
    public static final int TYPE_FIRE = 1;
    World worldObj;
    EntityLiving entityHost;
    EntityLivingBase attackTarget;
    double rangedAttackTime = 0.0;
    double rangedAttackDistance = 0.0;
    double entityMoveSpeed = 0.0;
    double maxRangedAttackTime = 10.0;
    int nbTarget = 0;
    int rangedAttackID;

    public EntityAIDistanceAttack(EntityLiving entityLiving, double entityMoveSpeed, double rangedAttackDistance, double rangedAttackTime, int rangedAttackID) {
        this.entityHost = entityLiving;
        this.worldObj = entityLiving.field_70170_p;
        this.entityMoveSpeed = entityMoveSpeed;
        this.rangedAttackDistance = rangedAttackDistance;
        this.maxRangedAttackTime = rangedAttackTime;
        this.rangedAttackID = rangedAttackID;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.entityHost.func_70638_az();
        if (target == null) {
            return false;
        }
        this.attackTarget = target;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
    }

    public void func_75246_d() {
        double distance = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v);
        boolean canSeeEntity = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.nbTarget = canSeeEntity ? ++this.nbTarget : 0;
        if (this.nbTarget >= 20) {
            this.entityHost.func_70661_as().func_75499_g();
        } else {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, (float)this.rangedAttackDistance, (float)this.rangedAttackDistance);
        this.rangedAttackTime = Math.max(this.rangedAttackTime - 1.0, 0.0);
        if (this.rangedAttackTime <= 0.0 && canSeeEntity) {
            ModCastleDefenders.log.debug(new Object[]{"updateTask : rangedAttackTime=" + this.rangedAttackTime});
            this.doRangedAttack();
            this.rangedAttackTime = this.maxRangedAttackTime;
        }
    }

    private void doRangedAttack() {
        Random random = new Random();
        switch (this.rangedAttackID) {
            default: {
                EntityArrow eArrow = new EntityArrow(this.worldObj, (EntityLivingBase)this.entityHost, this.attackTarget, 1.6f, 12.0f);
                this.worldObj.func_72956_a((Entity)this.entityHost, "random.bow", 1.0f, 1.0f / (this.entityHost.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.worldObj.func_72838_d((Entity)eArrow);
                break;
            }
            case 1: {
                ModCastleDefenders.log.debug(new Object[]{"Attack Fire"});
                int x = MathHelper.func_76128_c((double)this.attackTarget.field_70165_t) + random.nextInt(5) - 2;
                int y = MathHelper.func_76128_c((double)this.attackTarget.field_70163_u);
                int z = MathHelper.func_76128_c((double)(this.attackTarget.field_70161_v + (double)random.nextInt(5) - 2.0));
                for (int i = 0; i < 2 && !this.worldObj.func_147437_c(x, y, z); ++i) {
                    ++y;
                }
                if (!this.worldObj.func_147437_c(x, y, z)) break;
                this.worldObj.func_147465_d(x, y, z, (Block)Blocks.field_150480_ab, 0, 3);
                this.worldObj.func_72908_a((double)x, (double)y, (double)z, "ambient.weather.thunder", 2.0f, 0.8f + random.nextFloat() * 0.2f);
                this.worldObj.func_72908_a((double)x, (double)y, (double)z, "random.explode", 2.0f, 0.6f + random.nextFloat() * 0.2f);
                if (random.nextInt(3) != 0) break;
                this.entityHost.func_70652_k((Entity)this.attackTarget);
            }
        }
    }
}

