/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.ModCastleDefenders;
import com.gollum.castledefenders.common.entities.EntityMerc;
import com.gollum.castledefenders.inits.ModBlocks;
import com.gollum.core.common.config.type.ItemStackConfigType;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityHealer
extends EntityMerc {
    private static final int maxCouldDownMusic = 300;
    int couldDown = 0;
    int couldDownMusic = 300;

    public EntityHealer(World world) {
        super(world);
        this.blockSpawn = ModBlocks.blockHealer;
        this.defaultHeldItem = new ItemStack(Items.book, 1);
    }

    @Override
    protected MobCapacitiesConfigType getCapacities() {
        return ModCastleDefenders.config.healerCapacities;
    }

    @Override
    protected ItemStackConfigType[] getCost() {
        return ModCastleDefenders.config.healerCost;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if ((double)this.couldDown > this.getTimeRange()) {
            this.healEntitiesNearby();
        } else {
            ++this.couldDown;
        }
        if (this.couldDownMusic <= 300) {
            ++this.couldDownMusic;
        }
    }

    private void healEntitiesNearby() {
        List entitiesNearby = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)(this.posX - this.getFollowRange()), (double)(this.posY - this.getFollowRange()), (double)(this.posZ - this.getFollowRange()), (double)(this.posX + this.getFollowRange()), (double)(this.posY + this.getFollowRange()), (double)(this.posZ + this.getFollowRange())));
        for (EntityPlayer player : entitiesNearby) {
            if (!this.isOwner(player) || player.getHealth() == player.getMaxHealth()) continue;
            if (this.couldDownMusic > 300) {
                this.couldDownMusic = 0;
                this.worldObj.playSoundAtEntity((Entity)this, "CastleDefenders".toLowerCase() + ":monk", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.2f);
            }
            ModCastleDefenders.log.debug(new Object[]{"Heal player"});
            player.heal(ModCastleDefenders.config.healPointByTimeRange);
            this.couldDown = 0;
        }
    }
}

