/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.tileentities;

import com.gollum.castledefenders.ModCastleDefenders;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class TileEntityBlockCastleDefenders
extends TileEntity {
    public int delay = 20;
    protected int minSpawnDelay = 200;
    protected int maxSpawnDelay = 800;
    protected int maxSpawn = 0;
    private String mobID;

    public TileEntityBlockCastleDefenders(String mobID) {
        this.mobID = mobID;
    }

    public String getMobID() {
        return this.mobID;
    }

    public boolean anyPlayerInRange() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 16.0) != null;
    }

    private void updateDelay() {
        this.delay = this.minSpawnDelay + this.worldObj.rand.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
    }

    public void updateEntity() {
        if (this.anyPlayerInRange() && !this.worldObj.isRemote) {
            if (this.delay == -1) {
                this.updateDelay();
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            Entity entity = EntityList.createEntityByName((String)this.mobID, (World)this.worldObj);
            if (entity == null) {
                ModCastleDefenders.log.warning(new Object[]{"This mob " + this.mobID + " isn't  register"});
                return;
            }
            int nbEntityArround = this.worldObj.getEntitiesWithinAABB(entity.getClass(), AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(12.0, 4.0, 12.0)).size();
            if (nbEntityArround >= this.maxSpawn) {
                this.updateDelay();
                return;
            }
            double x = (double)this.xCoord + 0.5;
            double y = this.yCoord + 1;
            double z = (double)this.zCoord + 0.5;
            EntityLiving entityLiving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
            entity.setLocationAndAngles(x, y, z, this.worldObj.rand.nextFloat() * 360.0f, this.worldObj.rand.nextFloat() * 360.0f);
            if (entityLiving == null || entityLiving.getCanSpawnHere()) {
                this.worldObj.spawnEntityInWorld(entity);
                this.worldObj.playSoundEffect((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, "dig.stone", 0.5f, this.worldObj.rand.nextFloat() * 0.25f + 0.6f);
                if (entityLiving != null) {
                    entityLiving.spawnExplosionParticle();
                }
                this.updateDelay();
            }
        }
    }

    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        this.delay = var1.getShort("Delay");
    }

    public void writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        var1.setShort("Delay", (short)this.delay);
    }
}

