/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.common.entities.EntityDefender;
import com.gollum.castledefenders.common.entities.EntityMercenary;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityEnemy
extends EntityMob {
    protected ItemStack defaultHeldItem = null;
    protected Block blockSpawn;
    private int idTask = 0;
    private int idTargetTask = 0;

    public EntityEnemy(World world) {
        super(world);
        this.setSize(1.1f, 1.8f);
        this.getNavigator().setBreakDoors(false);
        this.getNavigator().setAvoidsWater(true);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(this.getMoveSpeed());
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(this.getMaxHealt());
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(this.getFollowRange());
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(this.getAttackStrength());
        this.getNavigator().setBreakDoors(true);
        this.tasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAIWander((EntityCreature)this, this.getMoveSpeed()));
        this.targetTasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.targetTasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDefender.class, 0, true));
        this.targetTasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMercenary.class, 0, true));
    }

    public int nextIdTask() {
        return this.idTask++;
    }

    public int nextIdTargetTask() {
        return this.idTargetTask++;
    }

    protected double getMoveSpeed() {
        return this.getCapacities().moveSpeed;
    }

    protected double getMaxHealt() {
        return this.getCapacities().maxHealt;
    }

    protected double getAttackStrength() {
        return this.getCapacities().attackStrength;
    }

    protected double getFollowRange() {
        return this.getCapacities().followRange;
    }

    protected double getTimeRange() {
        return this.getCapacities().timeRange;
    }

    protected abstract MobCapacitiesConfigType getCapacities();

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(this.getMoveSpeed());
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(this.getMaxHealt());
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(this.getFollowRange());
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(this.getAttackStrength());
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected int getDropItemId() {
        return 0;
    }

    public boolean getCanSpawnHere() {
        int x = MathHelper.floor_double((double)this.posX);
        int y = MathHelper.floor_double((double)this.boundingBox.minY);
        int z = MathHelper.floor_double((double)this.posZ);
        Block block = this.worldObj.getBlock(x, y - 1, z);
        Block up1 = this.worldObj.getBlock(x, y, z);
        Block up2 = this.worldObj.getBlock(x, y + 1, z);
        List entityListBlockArround = this.worldObj.getEntitiesWithinAABB(((Object)((Object)this)).getClass(), AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(2.0, 2.0, 2.0));
        boolean found = false;
        for (Object arroundEntity : entityListBlockArround) {
            if (arroundEntity.getClass() != ((Object)((Object)this)).getClass()) continue;
            found = true;
        }
        return !(block != this.blockSpawn || up1 != null && !(up1 instanceof BlockAir) && up1.isCollidable() || up2 != null && !(up2 instanceof BlockAir) && up2.isCollidable() || found);
    }

    public ItemStack getHeldItem() {
        if (this.defaultHeldItem == null) {
            return super.getHeldItem();
        }
        return this.defaultHeldItem;
    }
}

