/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.aientities;

import com.gollum.castledefenders.ModCastleDefenders;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityAIDistanceAttack
extends EntityAIBase {
    public static final int TYPE_ARROW = 0;
    public static final int TYPE_FIRE = 1;
    World worldObj;
    EntityLiving entityHost;
    EntityLivingBase attackTarget;
    double rangedAttackTime = 0.0;
    double rangedAttackDistance = 0.0;
    double entityMoveSpeed = 0.0;
    double maxRangedAttackTime = 10.0;
    int nbTarget = 0;
    int rangedAttackID;

    public EntityAIDistanceAttack(EntityLiving entityLiving, double entityMoveSpeed, double rangedAttackDistance, double rangedAttackTime, int rangedAttackID) {
        this.entityHost = entityLiving;
        this.worldObj = entityLiving.worldObj;
        this.entityMoveSpeed = entityMoveSpeed;
        this.rangedAttackDistance = rangedAttackDistance;
        this.maxRangedAttackTime = rangedAttackTime;
        this.rangedAttackID = rangedAttackID;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        EntityLivingBase target = this.entityHost.getAttackTarget();
        if (target == null) {
            return false;
        }
        this.attackTarget = target;
        return true;
    }

    public boolean continueExecuting() {
        return this.shouldExecute() || !this.entityHost.getNavigator().noPath();
    }

    public void resetTask() {
        this.attackTarget = null;
    }

    public void updateTask() {
        double distance = this.entityHost.getDistanceSq(this.attackTarget.posX, this.attackTarget.boundingBox.minY, this.attackTarget.posZ);
        boolean canSeeEntity = this.entityHost.getEntitySenses().canSee((Entity)this.attackTarget);
        this.nbTarget = canSeeEntity ? ++this.nbTarget : 0;
        if (this.nbTarget >= 20) {
            this.entityHost.getNavigator().clearPathEntity();
        } else {
            this.entityHost.getNavigator().tryMoveToEntityLiving((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.getLookHelper().setLookPositionWithEntity((Entity)this.attackTarget, (float)this.rangedAttackDistance, (float)this.rangedAttackDistance);
        this.rangedAttackTime = Math.max(this.rangedAttackTime - 1.0, 0.0);
        if (this.rangedAttackTime <= 0.0 && canSeeEntity) {
            ModCastleDefenders.log.debug(new Object[]{"updateTask : rangedAttackTime=" + this.rangedAttackTime});
            this.doRangedAttack();
            this.rangedAttackTime = this.maxRangedAttackTime;
        }
    }

    private void doRangedAttack() {
        Random random = new Random();
        switch (this.rangedAttackID) {
            default: {
                EntityArrow eArrow = new EntityArrow(this.worldObj, (EntityLivingBase)this.entityHost, this.attackTarget, 1.6f, 12.0f);
                this.worldObj.playSoundAtEntity((Entity)this.entityHost, "random.bow", 1.0f, 1.0f / (this.entityHost.getRNG().nextFloat() * 0.4f + 0.8f));
                this.worldObj.spawnEntityInWorld((Entity)eArrow);
                break;
            }
            case 1: {
                ModCastleDefenders.log.debug(new Object[]{"Attack Fire"});
                int x = MathHelper.floor_double((double)this.attackTarget.posX) + random.nextInt(5) - 2;
                int y = MathHelper.floor_double((double)this.attackTarget.posY);
                int z = MathHelper.floor_double((double)(this.attackTarget.posZ + (double)random.nextInt(5) - 2.0));
                for (int i = 0; i < 2 && !this.worldObj.isAirBlock(x, y, z); ++i) {
                    ++y;
                }
                if (!this.worldObj.isAirBlock(x, y, z)) break;
                this.worldObj.setBlock(x, y, z, (Block)Blocks.fire, 0, 3);
                this.worldObj.playSoundEffect((double)x, (double)y, (double)z, "ambient.weather.thunder", 2.0f, 0.8f + random.nextFloat() * 0.2f);
                this.worldObj.playSoundEffect((double)x, (double)y, (double)z, "random.explode", 2.0f, 0.6f + random.nextFloat() * 0.2f);
                if (random.nextInt(3) != 0) break;
                this.entityHost.attackEntityAsMob((Entity)this.attackTarget);
            }
        }
    }
}

