/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.client.render;

import com.gollum.castledefenders.ModCastleDefenders;
import com.gollum.castledefenders.client.render.RenderCastleDefenders;
import com.gollum.castledefenders.common.entities.EntityMercenary;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderMercCastleDefenders
extends RenderCastleDefenders {
    public RenderMercCastleDefenders(String name) {
        super(name);
    }

    @Override
    protected ResourceLocation getEntityTexture(Entity entity) {
        if (entity instanceof EntityTameable) {
            return this.getResource(((EntityTameable)entity).isTamed() ? this.name + "2" : this.name);
        }
        return this.getResource(this.name);
    }

    public void doRender(Entity entity, double x, double y, double z, float par8, float par9) {
        super.doRender(entity, x, y, z, par8, par9);
        EntityMercenary entityMercenary = (EntityMercenary)entity;
        if (entityMercenary.isTamed()) {
            if (entityMercenary.isOwner()) {
                this.renderLife((EntityLivingBase)entityMercenary, x, y, z);
            }
        } else {
            this.func_147906_a((Entity)entityMercenary, entityMercenary.getMessagePlayer(), x, y, z, 64);
        }
        GL11.glPushMatrix();
        this.modelBipedMain.bipedRightArm.rotateAngleY = 1.6f;
        this.modelBipedMain.bipedRightArm.postRender(0.0222f);
        GL11.glPopMatrix();
    }

    protected void renderLife(EntityLivingBase entityLivingBase, double x, double y, double z) {
        boolean display = ModCastleDefenders.proxy.getDisplayHealth();
        if (display && ModCastleDefenders.config.displayMercenaryLife) {
            EntityMercenary entityMerc = (EntityMercenary)entityLivingBase;
            float zoom = 0.026666671f;
            Tessellator tessellator = Tessellator.instance;
            double top = -ModCastleDefenders.config.mercenaryLifeTop;
            double height = ModCastleDefenders.config.mercenaryLifeHeight;
            double width = ModCastleDefenders.config.mercenaryLifeWidth;
            GL11.glDisable((int)3553);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 0.1f), (float)((float)z));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)(-zoom), (float)(-zoom), (float)zoom);
            GL11.glDisable((int)2896);
            tessellator.startDrawingQuads();
            float Health = entityMerc.getHealth();
            float MaxHealth = entityMerc.getMaxHealth();
            float ratio = Health / MaxHealth;
            double sizeUse = width * (double)ratio;
            tessellator.setColorRGBA_F(0.7f, 0.0f, 0.0f, 1.0f);
            tessellator.addVertex(-width / 2.0 + sizeUse, -height + top, 0.0);
            tessellator.addVertex(-width / 2.0 + sizeUse, top, 0.0);
            tessellator.addVertex(width / 2.0, top, 0.0);
            tessellator.addVertex(width / 2.0, -height + top, 0.0);
            tessellator.setColorRGBA_F(0.0f, 0.7f, 0.0f, 1.0f);
            tessellator.addVertex(-width / 2.0, -height + top, 0.0);
            tessellator.addVertex(-width / 2.0, top, 0.0);
            tessellator.addVertex(sizeUse - width / 2.0, top, 0.0);
            tessellator.addVertex(sizeUse - width / 2.0, -height + top, 0.0);
            tessellator.draw();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }
}

