/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.ModCastleDefenders;
import com.gollum.core.common.config.type.ItemStackConfigType;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityMercenary
extends EntityTameable {
    protected ItemStack defaultHeldItem = null;
    protected int blockSpawnId;
    private int idTask = 0;
    private int idTargetTask = 0;
    private ArrayList<String> ownerList = new ArrayList();
    private int eating = -1;

    public EntityMercenary(World world) {
        super(world);
        this.setSize(1.1f, 1.8f);
        this.getNavigator().setBreakDoors(true);
        this.getNavigator().setAvoidsWater(false);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setAttribute(this.getMoveSpeed());
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setAttribute(this.getMaxHealt());
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setAttribute(this.getFollowRange());
        float follow = Math.min((float)(this.getFollowRange() - 1.0), 10.0f);
        if (follow < 1.0f) {
            follow = 1.0f;
        }
        this.tasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(this.nextIdTask(), (EntityAIBase)this.aiSit);
        this.tasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.tasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, this.getMaxSpeed(), follow, 1.0f));
        this.targetTasks.addTask(this.nextIdTargetTask(), (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.targetTasks.addTask(this.nextIdTargetTask(), (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(this.nextIdTargetTask(), (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(this.nextIdTargetTask(), (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, IMob.class, 200, false));
        this.targetTasks.addTask(this.nextIdTargetTask(), (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, IMob.class, 0, true));
    }

    public int nextIdTask() {
        return this.idTask++;
    }

    public int nextIdTargetTask() {
        return this.idTargetTask++;
    }

    protected double getMinSpeed() {
        return 0.0;
    }

    protected double getMaxSpeed() {
        return this.getCapacities().moveSpeed;
    }

    protected double getMoveSpeed() {
        return this.isTamed() ? this.getMaxSpeed() : this.getMinSpeed();
    }

    protected double getMaxHealt() {
        return this.getCapacities().maxHealt;
    }

    protected double getAttackStrength() {
        return this.getCapacities().attackStrength;
    }

    protected double getFollowRange() {
        return this.getCapacities().followRange;
    }

    protected double getTimeRange() {
        return this.getCapacities().timeRange;
    }

    protected abstract MobCapacitiesConfigType getCapacities();

    protected abstract ItemStackConfigType[] getCost();

    @SideOnly(value=Side.CLIENT)
    public String getMessagePlayer() {
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        ItemStack stack = null;
        stack = this.hasBuyItemInHand((EntityPlayer)player);
        if (stack != null) {
            return ModCastleDefenders.i18n.trans("message.okfor", new Object[]{stack.stackSize, Item.itemsList[stack.itemID].getStatName()});
        }
        return ModCastleDefenders.i18n.trans("message.buymercenary", new Object[0]);
    }

    public ItemStack hasBuyItemInHand(EntityPlayer player) {
        ItemStack item = player.inventory.getCurrentItem();
        if (item != null) {
            if (this.getCapacities() == null) {
                return null;
            }
            for (ItemStackConfigType config : this.getCost()) {
                ItemStack cStack = config.getItemStak();
                if (cStack.itemID != item.itemID) continue;
                return cStack;
            }
        }
        return null;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setAttribute(this.getMoveSpeed());
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setAttribute(this.getMaxHealt());
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setAttribute(this.getFollowRange());
    }

    public void setTamed(boolean tamed) {
        super.setTamed(tamed);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setAttribute(this.getMoveSpeed());
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setAttribute(this.getMaxHealt());
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        this.dataWatcher.updateObject(18, (Object)new Integer((int)this.getHealth()));
    }

    protected void playTameEffect(boolean var1) {
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (Object)new Integer((int)this.getHealth()));
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        int i = 0;
        for (String owner : this.ownerList) {
            nbt.setString("owner" + i, owner);
            ModCastleDefenders.log.debug(new Object[]{"Write owner" + i + " : " + owner});
            ++i;
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        int i = 0;
        this.ownerList.clear();
        String owner = null;
        do {
            owner = null;
            try {
                owner = nbt.getString("owner" + i);
            }
            catch (Exception e) {
                owner = null;
            }
            if (owner != null && !owner.equals("") && !this.ownerList.contains(owner)) {
                ModCastleDefenders.log.debug(new Object[]{"Read NBT merc owner: " + owner});
                this.ownerList.add(owner);
            }
            ++i;
        } while (owner != null && !owner.equals(""));
    }

    public boolean canAttackClass(Class var1) {
        return EntityGhast.class != var1 && !EntityMercenary.class.isAssignableFrom(var1);
    }

    protected boolean canDespawn() {
        return false;
    }

    public int getMaxSpawnedInChunk() {
        return 8;
    }

    public boolean getCanSpawnHere() {
        int x = MathHelper.floor_double((double)this.posX);
        int y = MathHelper.floor_double((double)this.boundingBox.minY);
        int z = MathHelper.floor_double((double)this.posZ);
        int idBlock = this.worldObj.getBlockId(x, y - 1, z);
        int up1 = this.worldObj.getBlockId(x, y, z);
        int up2 = this.worldObj.getBlockId(x, y + 1, z);
        List entityListBlockArround = this.worldObj.getEntitiesWithinAABB(((Object)((Object)this)).getClass(), AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(2.0, 2.0, 2.0));
        boolean found = false;
        for (Object arroundEntity : entityListBlockArround) {
            if (arroundEntity.getClass() != ((Object)((Object)this)).getClass()) continue;
            found = true;
        }
        return !(idBlock != this.blockSpawnId || up1 != 0 && Block.blocksList[up1].isCollidable() || up2 != 0 && Block.blocksList[up2].isCollidable() || found);
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected int getDropItemId() {
        return 0;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.worldObj.isRemote) {
            EntityClientPlayerMP entityClientPlayerMP = Minecraft.getMinecraft().thePlayer;
        }
        if (this.eating >= 0) {
            if (this.eating % 4 == 0) {
                this.worldObj.playSoundAtEntity((Entity)this, "random.eat", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
            }
            ++this.eating;
            if (this.eating == 10) {
                this.eating = -1;
            }
        }
    }

    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    protected void attackEntity(Entity entity, float var2) {
        if (this.attackTime <= 0 && var2 < 2.0f && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 10;
            this.attackEntityAsMob(entity);
        }
    }

    public boolean attackEntityFrom(DamageSource damageSource, float strength) {
        if (super.attackEntityFrom(damageSource, strength)) {
            Entity entity = damageSource.getEntity();
            if (this.riddenByEntity != entity && this.ridingEntity != entity) {
                if (entity != this) {
                    this.entityToAttack = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean attackEntityAsMob(Entity entity) {
        double strength = this.getAttackStrength();
        if (this.isPotionActive(Potion.damageBoost)) {
            strength += (double)(3 << this.getActivePotionEffect(Potion.damageBoost).getAmplifier());
        }
        if (this.isPotionActive(Potion.weakness)) {
            strength -= (double)(2 << this.getActivePotionEffect(Potion.weakness).getAmplifier());
        }
        return entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)strength);
    }

    private boolean buy(EntityPlayer player, Class itemClass, int nb) {
        return this.buy(player, 0, itemClass, nb);
    }

    private boolean buy(EntityPlayer player, int itemId, int nb) {
        return this.buy(player, itemId, null, nb);
    }

    private boolean buy(EntityPlayer player, int itemId, Class itemClass, int nb) {
        ItemStack item = player.inventory.getCurrentItem();
        if (item != null && item.stackSize >= nb && (itemClass != null && itemClass.isInstance(Item.itemsList[item.itemID]) || itemId != 0 && item.itemID == itemId)) {
            if (!player.capabilities.isCreativeMode) {
                item.stackSize -= nb;
            }
            if (item.stackSize <= 0) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
            }
            return true;
        }
        return false;
    }

    private void linkOwner(EntityPlayer player) {
        this.setPathToEntity(null);
        this.setAttackTarget(null);
        this.isJumping = false;
        if (player != null) {
            this.setTamed(true);
            this.setOwner(player.getUniqueID().toString());
            if (!this.ownerList.contains(player.getUniqueID().toString())) {
                this.ownerList.add(player.getUniqueID().toString());
            }
        } else {
            this.setTamed(false);
            this.setOwner("");
        }
        this.worldObj.setEntityState((Entity)this, (byte)7);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setAttribute(this.getMoveSpeed());
    }

    public boolean interact(EntityPlayer player) {
        ItemStack item = player.inventory.getCurrentItem();
        if (!this.worldObj.isRemote) {
            if (!this.isTamed()) {
                boolean buy = this.isAlraidyBuy(player);
                if (!buy) {
                    for (ItemStackConfigType stackConfig : this.getCost()) {
                        ItemStack stack = stackConfig.getItemStak();
                        buy = this.buy(player, stack.itemID, stack.stackSize);
                        if (buy) break;
                    }
                }
                if (buy) {
                    this.linkOwner(player);
                    return true;
                }
            } else if (this.getOwnerName().equals(player.getUniqueID().toString())) {
                ModCastleDefenders.log.debug(new Object[]{"Interract with owner: " + player.username});
                if (this.buy(player, ItemFood.class, 1)) {
                    ItemFood food = (ItemFood)Item.itemsList[item.itemID];
                    this.heal(food.getHealAmount());
                    this.worldObj.playSoundAtEntity((Entity)this, "random.eat", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                    this.eating = 0;
                    return true;
                }
                this.linkOwner(null);
                return true;
            }
        }
        return false;
    }

    public ItemStack getHeldItem() {
        if (this.defaultHeldItem == null) {
            return super.getHeldItem();
        }
        return this.defaultHeldItem;
    }

    public EntityAgeable createChild(EntityAgeable entityageable) {
        return null;
    }

    public boolean isAlraidyBuy(EntityPlayer player) {
        return this.ownerList.contains(player.getUniqueID().toString());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isOwner() {
        return this.isOwner((EntityPlayer)Minecraft.getMinecraft().thePlayer);
    }

    public boolean isOwner(EntityPlayer player) {
        return this.getOwnerName().equals(player.getUniqueID().toString());
    }
}

