/*
 * Decompiled with CFR 0.152.
 */
package com.gollum.castledefenders.common.entities;

import com.gollum.castledefenders.inits.ModItems;
import com.gollum.core.common.config.type.MobCapacitiesConfigType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityDefender
extends EntityAnimal {
    protected ItemStack defaultHeldItem = null;
    protected int blockSpawnId;
    private int idTask = 0;
    private int idTargetTask = 0;

    public EntityDefender(World world) {
        super(world);
        this.setSize(1.1f, 1.8f);
        this.getNavigator().setBreakDoors(true);
        this.getNavigator().setAvoidsWater(true);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setAttribute(this.getMoveSpeed());
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setAttribute(this.getMaxHealt());
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setAttribute(this.getFollowRange());
        this.tasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)0.35f, ModItems.itemMedallion.itemID, false));
        this.tasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(this.nextIdTask(), (EntityAIBase)new EntityAIWander((EntityCreature)this, this.getMoveSpeed()));
    }

    public int nextIdTask() {
        return this.idTask++;
    }

    public int nextIdTargetTask() {
        return this.idTargetTask++;
    }

    protected double getMoveSpeed() {
        return this.getCapacities().moveSpeed;
    }

    protected double getMaxHealt() {
        return this.getCapacities().maxHealt;
    }

    protected double getAttackStrength() {
        return this.getCapacities().attackStrength;
    }

    protected double getFollowRange() {
        return this.getCapacities().followRange;
    }

    protected double getTimeRange() {
        return this.getCapacities().timeRange;
    }

    protected abstract MobCapacitiesConfigType getCapacities();

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setAttribute(this.getMoveSpeed());
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setAttribute(this.getMaxHealt());
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setAttribute(this.getFollowRange());
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void attackEntity(Entity entity, float var2) {
        if (this.attackTime <= 0 && var2 < 2.0f && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 10;
            this.attackEntityAsMob(entity);
        }
    }

    public boolean attackEntityFrom(DamageSource damageSource, float strength) {
        if (super.attackEntityFrom(damageSource, strength)) {
            Entity entity = damageSource.getEntity();
            if (this.riddenByEntity != entity && this.ridingEntity != entity) {
                if (entity != this) {
                    this.entityToAttack = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean canAttackClass(Class entityClass) {
        return EntityGhast.class != entityClass;
    }

    public boolean attackEntityAsMob(Entity entity) {
        double strength = this.getAttackStrength();
        if (this.isPotionActive(Potion.damageBoost)) {
            strength += (double)(3 << this.getActivePotionEffect(Potion.damageBoost).getAmplifier());
        }
        if (this.isPotionActive(Potion.weakness)) {
            strength -= (double)(2 << this.getActivePotionEffect(Potion.weakness).getAmplifier());
        }
        return entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)strength);
    }

    public boolean getCanSpawnHere() {
        int x = MathHelper.floor_double((double)this.posX);
        int y = MathHelper.floor_double((double)this.boundingBox.minY);
        int z = MathHelper.floor_double((double)this.posZ);
        int idBlock = this.worldObj.getBlockId(x, y - 1, z);
        int up1 = this.worldObj.getBlockId(x, y, z);
        int up2 = this.worldObj.getBlockId(x, y + 1, z);
        List entityListBlockArround = this.worldObj.getEntitiesWithinAABB(((Object)((Object)this)).getClass(), AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(2.0, 2.0, 2.0));
        boolean found = false;
        for (Object arroundEntity : entityListBlockArround) {
            if (arroundEntity.getClass() != ((Object)((Object)this)).getClass()) continue;
            found = true;
        }
        return !(idBlock != this.blockSpawnId || up1 != 0 && Block.blocksList[up1].isCollidable() || up2 != 0 && Block.blocksList[up2].isCollidable() || found);
    }

    public ItemStack getHeldItem() {
        if (this.defaultHeldItem == null) {
            return super.getHeldItem();
        }
        return this.defaultHeldItem;
    }

    public EntityAgeable createChild(EntityAgeable entityageable) {
        return null;
    }
}

